<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Variables to hold unit strings -->
    <xsl:variable name="linearUnit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">ft</xsl:when>
            <xsl:otherwise>m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit1">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">sq ft</xsl:when>
            <xsl:otherwise>sq m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit2">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">ac</xsl:when>
            <xsl:otherwise>hec</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Variables to hold Direction Method, Format, Precision and Mode -->
    <xsl:variable name="mapCheckAngularMethod">
        <xsl:choose>
            <xsl:when test="//@angularUnits = 'Grads'">2</xsl:when>
            <xsl:when test="//@angularUnits = 'Radians'">3</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mapCheckDirectionFormat">
        <xsl:choose>
            <xsl:when test="//@directionFormat = 'Decimal Degrees'">2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mapCheckDirectionPrecision" select="number(//@directionPrecision)"/>
    <xsl:variable name="mapCheckDirectionModeFormat">
        <xsl:choose>
            <xsl:when test="//@directionMode = 'North Bearing'">2</xsl:when>
            <xsl:when test="//@directionMode = 'North Azimuth'">3</xsl:when>
            <xsl:when test="//@directionMode = 'South Azimuth'">4</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Map Check Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis map kontroly</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis map kontroly</h2>
                                <p lang="en">
                                    Datum Výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Vstupní koeficient rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%"><xsl:value-of select="../@inputGridScaleFactor" /></td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <table class="margin" width="75%">
                                    <colgroup span="5">
                                        <col width="12%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                    </colgroup>
                                    <xsl:for-each select="HorizontalAlignment">
                                        <thead>
                                            <tr><td colspan="5">&#xa0;</td></tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Název trasy:&#xa0; </th>
                                                <td align="left" colspan="3"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Popis trasy:&#xa0; </th>
                                                <td align="left" colspan="3"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr><td colspan="5">&#xa0;</td></tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <th class="underline">Typ</th>
                                                <th class="underline">Název bodu/<br/>Směr</th>
                                                <th class="underline">Y/<br/>Délka</th>
                                                <th class="underline">X</th>
                                                <th class="underline">Z</th>
                                            </tr>
                                            <tr>
                                                <xsl:for-each select="HorizontalElements">
                                                    <xsl:apply-templates select="//HorizontalLine | //HorizontalCircle | //HorizontalSpiral"/>
                                                </xsl:for-each>
                                            </tr>
                                            <tr><td colspan="5">&#xa0;</td></tr>
                                            <tr>
                                                <td colspan="4">
                                                    <xsl:if test="@northingClosingError">
                                                        <table width="100%">
                                                            <tr>
                                                                <th align="left" lang="en">Y chyba: &#xa0;</th>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@northingClosingError))"/>
                                                                </td>
                                                                <td><xsl:value-of select="$linearUnit"/></td>
                                                                <td colspan="2">&#xa0;</td>
                                                            </tr>
                                                            <tr>
                                                                <th align="left" lang="en">X chyba: &#xa0;</th>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@eastingClosingError))"/>
                                                                </td>
                                                                <td><xsl:value-of select="$linearUnit"/></td>
                                                                <td colspan="2">&#xa0;</td>
                                                            </tr>
                                                            <tr>
                                                                <th align="left" lang="en">Směr uzavření: &#xa0;</th>
                                                                <td align="right" nowrap="nowrap">
                                                                    <xsl:value-of select="cif:directionFormat(number(@closingDirection))"/>
                                                                </td>
                                                                <td colspan="3">&#xa0;</td>
                                                            </tr>
                                                            <tr>
                                                                <th align="left" lang="en">Vzdálenost uzavření: &#xa0;</th>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@closingDistance))"/>
                                                                </td>
                                                                <td><xsl:value-of select="$linearUnit"/></td>
                                                                <td colspan="2">&#xa0;</td>
                                                            </tr>
                                                            <xsl:if test="@area">
                                                                <tr>
                                                                    <th align="left" lang="en">Plocha uzavření: &#xa0;</th>
                                                                    <td align="right">
                                                                        <xsl:value-of select="cif:areaFormat(number(@area))"/>
                                                                    </td>
                                                                    <td style="white-space:nowrap"><xsl:value-of select="$areaUnit1"/></td>
                                                                    <xsl:choose>
                                                                        <xsl:when test="//@linearUnits = 'Imperial'">
                                                                            <td align="right">
                                                                                <xsl:value-of select="cif:areaFormat(number(@area div 43560))"/>
                                                                            </td>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <td align="right">
                                                                                <xsl:value-of select="cif:areaFormat(number(@area div 10000))"/>
                                                                            </td>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                    <td style="white-space:nowrap"><xsl:value-of select="$areaUnit2"/></td>
                                                                </tr>
                                                                <tr>
                                                                    <th align="left" lang="en">Obvod: &#xa0;</th>
                                                                    <td align="right">
                                                                        <xsl:value-of select="cif:distanceFormat(number(@perimeter))"/>
                                                                    </td>
                                                                    <td><xsl:value-of select="$linearUnit"/></td>
                                                                    <td colspan="2">&#xa0;</td>
                                                                </tr>
                                                            </xsl:if>
                                                            <tr>
                                                                <th align="left" lang="en">Přesnost: &#xa0;</th>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@closingPrecision))"/>
                                                                </td>
                                                                <td>&#xa0;</td>
                                                                <td colspan="2">&#xa0;</td>
                                                            </tr>
                                                        </table>
                                                    </xsl:if>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Horizontal Linear Data -->
    <xsl:template match="HorizontalLine">
        <tr>
            <td>
                <xsl:value-of select="Start/@type"/>
            </td>
            <td align="right">
                <xsl:if test="Start/@name">
                    (<xsl:value-of select="Start/@name"/>)
                </xsl:if>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td/>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
            <td colspan="2">&#xa0;</td>
        </tr>
        <xsl:if test="position() = last()">
            <tr>
                <td>
                    <xsl:value-of select="End/@type"/>
                </td>
                <td align="right">
                    <xsl:if test="End/@name">
                        (<xsl:value-of select="End/@name"/>)
                    </xsl:if>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@elevation))"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <xsl:template match="HorizontalCircle">
        <tr>
            <td>
                <xsl:value-of select="Start/@type"/>
            </td>
            <td align="right">
                <xsl:if test="Start/@name">
                    (<xsl:value-of select="Start/@name"/>)
                </xsl:if>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td/>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@radialDirectionStart))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>
            <td colspan="2">&#xa0;</td>
        </tr>
        <tr>
            <td>
                <xsl:value-of select="Center/@type"/>
            </td>
            <td align="right">
                <xsl:if test="Center/@name">
                    (<xsl:value-of select="Center/@name"/>)
                </xsl:if>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Center/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Center/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Center/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td/>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@radialDirectionEnd))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
            </td>
            <td colspan="2">&#xa0;</td>
        </tr>
        <xsl:if test="position() = last()">
            <tr>
                <td>
                    <xsl:value-of select="End/@type"/>
                </td>
                <td align="right">
                    <xsl:if test="End/@name">
                        (<xsl:value-of select="End/@name"/>)
                    </xsl:if>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@elevation))"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <xsl:template match="HorizontalSpiral">
        <tr>
            <td>
                <xsl:value-of select="Start/@type"/>
            </td>
            <td align="right">
                <xsl:if test="Start/@name">
                    (<xsl:value-of select="Start/@name"/>)
                </xsl:if>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(Start/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td/>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))"/>
            </td>
            <td align="right">
                <xsl:choose>
                    <xsl:when test="@compound = 'false'">
                        <xsl:choose>
                            <xsl:when test="@startRadius &gt; @endRadius">
                                <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="@startRadius &gt; @endRadius">
                                <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td colspan="2">&#xa0;</td>
        </tr>
        <tr>
            <td>
                <xsl:value-of select="PI/@type"/>
            </td>
            <td align="right">
                <xsl:if test="PI/@name">
                    (<xsl:value-of select="PI/@name"/>)
                </xsl:if>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PI/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PI/@elevation))"/>
            </td>
        </tr>
        <tr>
            <td/>
            <td align="right" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))"/>
            </td>
            <td align="right">
                <xsl:choose>
                    <xsl:when test="@compound = 'false'">
                        <xsl:choose>
                            <xsl:when test="@startRadius &gt; @endRadius">
                                <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="@startRadius &gt; @endRadius">
                                <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td colspan="2">&#xa0;</td>
        </tr>
        <xsl:if test="position() = last()">
            <tr>
                <td>
                    <xsl:value-of select="End/@type"/>
                </td>
                <td align="right">
                    <xsl:if test="End/@name">
                        (<xsl:value-of select="End/@name"/>)
                    </xsl:if>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@northing))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@easting))"/>
                </td>
                <td align="right">
                    <xsl:value-of select="cif:ordinateFormat(number(End/@elevation))"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jedno směrové řešení v poli <em>Zahrnout</em> v příkazu 
                <em>Nástroje &gt; XML Výpisy &gt; Kontrolovat</em>.
            </p>
            <p class="normal1" lang="en">
                <strong>Poznámka:&#xa0; </strong>Většina délek a směrů v těle výpisu nepoužívá nastavení v 
                <em>Nástroje &gt; Možnosti formátu</em> v  menu
                <em>Průzkumník výpisů</em>.&#xa0;  Pouze hodnoty Y/X a hodnoty v zápatí používá toto nastavení.&#xa0; 
				Nastavení přesnosti pro délky a směry v těle výpisu pochází z <em>Nástroje &gt; XML Výpisy &gt; Kontrolovat</em> a formát směru a režim 
				pochází z <em>Nástroje &gt; Možnosti</em>.
            </p>
            <p class="normal1" lang="en">
                <strong>Poznámka Civil Nástroje:&#xa0; </strong>Nastavení přesnosti pro délky a směry v těle výpisu pochází z 
                <em>Nastavení Výkres</em>.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2007 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
